#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetFromFile(APIObject):
    """
    Attributes
    ----------
    file:file_type
         The data to be used for the creation.
    categories:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         An array of strings describing the intended use of the dataset.. 
    """
    _converter = t.Dict(
        {
            t.Key("file"):  t.String(),
            t.Key("categories", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        file,
        categories=None,
    ):
        self.file = file
        self.categories = categories

    def __repr__(self):
        return (
            "DatasetFromFile("
            "file={0.file}, "
            "categories={0.categories}, "
        ).format(self)
