#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetRefresh(APIObject):
    """
    Attributes
    ----------
    day_of_month:[str] [optional]
         The date(s) of the month that the job will run. Allowed values are either ``[1 ... 31]`` or ``[\"*\"]`` for all days of the month. This field is additive with ``dayOfWeek``, meaning the job will run both on the date(s) defined in this field and the day specified by ``dayOfWeek`` (for example, dates 1st, 2nd, 3rd, plus every Tuesday). If ``dayOfMonth`` is set to ``[\"*\"]`` and ``dayOfWeek`` is defined, the scheduler will trigger on every day of the month that matches ``dayOfWeek`` (for example, Tuesday the 2nd, 9th, 16th, 23rd, 30th). Invalid dates such as February 31st are ignored..  if omitted the server will use the default value of ["*"]
    day_of_week:[str] [optional]
         The day(s) of the week that the job will run. Allowed values are ``[0 .. 6]``, where (Sunday=0), or ``[\"*\"]``, for all days of the week. Strings, either 3-letter abbreviations or the full name of the day, can be used interchangeably (e.g., \"sunday\", \"Sunday\", \"sun\", or \"Sun\", all map to ``[0]``. This field is additive with ``dayOfMonth``, meaning the job will run both on the date specified by ``dayOfMonth`` and the day defined in this field..  if omitted the server will use the default value of ["*"]
    hour:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The hour(s) of the day that the job will run. Allowed values are ``[0 ... 23]``.. 
    minute:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The minute(s) of the day that the job will run. Allowed values are ``[0 ... 59]``.. 
    month:[str] [optional]
         The month(s) of the year that the job will run. Allowed values are either ``[1 ... 12]`` or ``[\"*\"]`` for all months of the year. Strings, either 3-letter abbreviations or the full name of the month, can be used interchangeably (e.g., \"jan\" or \"october\"). Months that are not compatible with ``dayOfMonth`` are ignored, for example ``{\"dayOfMonth\": [31], \"month\":[\"feb\"]}``..  if omitted the server will use the default value of ["*"]
    """
    _converter = t.Dict(
        {
            t.Key("day_of_month", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("day_of_week", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("hour", optional=True):  t.Any(),
            t.Key("minute", optional=True):  t.Any(),
            t.Key("month", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        day_of_month=None,
        day_of_week=None,
        hour=None,
        minute=None,
        month=None,
    ):
        self.day_of_month = day_of_month
        self.day_of_week = day_of_week
        self.hour = hour
        self.minute = minute
        self.month = month

    def __repr__(self):
        return (
            "DatasetRefresh("
            "day_of_month={0.day_of_month}, "
            "day_of_week={0.day_of_week}, "
            "hour={0.hour}, "
            "minute={0.minute}, "
            "month={0.month}, "
        ).format(self)
