#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetRefreshExecutionResult(APIObject):
    """
    Attributes
    ----------
    completed_at:datetime
         UTC completion date, in RFC-3339 format.
    dataset_id:str
         Dataset ID associated with this result.
    dataset_version_id:str
         Dataset version ID associated with this result
    execution_id:str
         Result ID.
    job_id:str
         Job ID associated with this result.
    message:str
         Current status of execution.
    started_at:datetime
         UTC start date, in RFC-3339 format.
    status:str
         Status of this dataset refresh.
    """
    _converter = t.Dict(
        {
            t.Key("completed_at"):  t.DateTime(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id"):  t.String(),
            t.Key("execution_id"):  t.String(),
            t.Key("job_id"):  t.String(),
            t.Key("message"):  t.String(),
            t.Key("started_at"):  t.DateTime(),
            t.Key("status"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        completed_at,
        dataset_id,
        dataset_version_id,
        execution_id,
        job_id,
        message,
        started_at,
        status,
    ):
        self.completed_at = completed_at
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.execution_id = execution_id
        self.job_id = job_id
        self.message = message
        self.started_at = started_at
        self.status = status

    def __repr__(self):
        return (
            "DatasetRefreshExecutionResult("
            "completed_at={0.completed_at}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "execution_id={0.execution_id}, "
            "job_id={0.job_id}, "
            "message={0.message}, "
            "started_at={0.started_at}, "
            "status={0.status}, "
        ).format(self)
