#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dataset_refresh import DatasetRefresh

class DatasetRefreshJobCreate(APIObject):
    """
    Attributes
    ----------
    name:str
         Scheduled job name.
    schedule:DatasetRefresh
        
    categories:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         An array of strings describing the intended use of the dataset. The supported options are ``TRAINING``, and ``PREDICTION``.. 
    credential_id:str, none_type [optional]
         The ID of the set of credentials to use to run the scheduled job when the Kerberos authentication service is utilized. Required when useKerberos is true..  if omitted the server will use the default value of "null"
    credentials:str [optional]
         A JSON string describing the data engine queries credentials to use when refreshing.. 
    enabled:bool [optional]
         Boolean for whether the scheduled job is active (true) or inactive (false)..  if omitted the server will use the default value of True
    schedule_reference_date:datetime [optional]
         The UTC reference date in RFC-3339 format of when the schedule starts from. This value is returned in `/api/v2/datasets/(datasetId)/refreshJobs/(jobId)/` to help build a more intuitive schedule picker. The default is the current time.. 
    use_kerberos:bool [optional]
         If true, the Kerberos authentication system is used in conjunction with a credential ID..  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("schedule"):  t.Any(),
            t.Key("categories", optional=True):  t.Any(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("credentials", optional=True):  t.String(),
            t.Key("enabled", optional=True):  t.Bool(),
            t.Key("schedule_reference_date", optional=True):  t.DateTime(),
            t.Key("use_kerberos", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        schedule,
        categories=None,
        credential_id=None,
        credentials=None,
        enabled=None,
        schedule_reference_date=None,
        use_kerberos=None,
    ):
        self.name = name
        self.schedule = schedule
        self.categories = categories
        self.credential_id = credential_id
        self.credentials = credentials
        self.enabled = enabled
        self.schedule_reference_date = schedule_reference_date
        self.use_kerberos = use_kerberos

    def __repr__(self):
        return (
            "DatasetRefreshJobCreate("
            "name={0.name}, "
            "schedule={0.schedule}, "
            "categories={0.categories}, "
            "credential_id={0.credential_id}, "
            "credentials={0.credentials}, "
            "enabled={0.enabled}, "
            "schedule_reference_date={0.schedule_reference_date}, "
            "use_kerberos={0.use_kerberos}, "
        ).format(self)
