#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dataset_refresh import DatasetRefresh

class DatasetRefreshJobResponse(APIObject):
    """
    Attributes
    ----------
    categories:bool, date, datetime, dict, float, int, list, str, none_type
         An array of strings describing the intended use of the dataset.
    created_by:str
         The user who created this dataset refresh job.
    credential_id:str, none_type
         ID used to validate with Kerberos authentication service if Kerberos is enabled.
    credentials:str
         A JSON string describing the data engine queries credentials to use when refreshing.
    dataset_id:str
         ID of the dataset the user scheduled job applies to.
    enabled:bool
         Indicates whether the scheduled job is active (true) or inactive(false).
    job_id:str
         The scheduled job ID.
    name:str
         The scheduled job's name.
    schedule:DatasetRefresh
        
    schedule_reference_date:datetime
         The UTC reference date in RFC-3339 format of when the schedule starts from. Can be used to help build a more intuitive schedule picker.
    updated_at:datetime
         The UTC date in RFC-3339 format of when the job was last updated.
    updated_by:str
         The user who last modified this dataset refresh job.
    use_kerberos:bool
         Boolean (true) if the Kerberos authentication service is needed when refreshing a job.
    """
    _converter = t.Dict(
        {
            t.Key("categories"):  t.Any(),
            t.Key("created_by"):  t.String(),
            t.Key("credential_id"):  t.String(),
            t.Key("credentials"):  t.String(),
            t.Key("dataset_id"):  t.String(),
            t.Key("enabled"):  t.Bool(),
            t.Key("job_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("schedule"):  t.Any(),
            t.Key("schedule_reference_date"):  t.DateTime(),
            t.Key("updated_at"):  t.DateTime(),
            t.Key("updated_by"):  t.String(),
            t.Key("use_kerberos"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        categories,
        created_by,
        credential_id,
        credentials,
        dataset_id,
        enabled,
        job_id,
        name,
        schedule,
        schedule_reference_date,
        updated_at,
        updated_by,
        use_kerberos,
    ):
        self.categories = categories
        self.created_by = created_by
        self.credential_id = credential_id
        self.credentials = credentials
        self.dataset_id = dataset_id
        self.enabled = enabled
        self.job_id = job_id
        self.name = name
        self.schedule = schedule
        self.schedule_reference_date = schedule_reference_date
        self.updated_at = updated_at
        self.updated_by = updated_by
        self.use_kerberos = use_kerberos

    def __repr__(self):
        return (
            "DatasetRefreshJobResponse("
            "categories={0.categories}, "
            "created_by={0.created_by}, "
            "credential_id={0.credential_id}, "
            "credentials={0.credentials}, "
            "dataset_id={0.dataset_id}, "
            "enabled={0.enabled}, "
            "job_id={0.job_id}, "
            "name={0.name}, "
            "schedule={0.schedule}, "
            "schedule_reference_date={0.schedule_reference_date}, "
            "updated_at={0.updated_at}, "
            "updated_by={0.updated_by}, "
            "use_kerberos={0.use_kerberos}, "
        ).format(self)
