#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetRelationshipResponse(APIObject):
    """
    Attributes
    ----------
    created_by:str
         The username of the user that created this relationship.
    creation_date:datetime
         ISO-8601 formatted time/date that this record was created.
    id:str
         ID of the dataset relationship
    linked_dataset_id:str
         ID of the linked dataset.
    linked_features:[str]
         List of features belonging to the linked dataset.
    modification_date:datetime
         ISO-8601 formatted time/date that this record was last updated.
    modified_by:str
         The username of the user that modified this relationship most recently.
    source_dataset_id:str
         ID of the source dataset.
    source_features:[str]
         List of features belonging to the source dataset.
    """
    _converter = t.Dict(
        {
            t.Key("created_by"):  t.String(),
            t.Key("creation_date"):  t.DateTime(),
            t.Key("id"):  t.String(),
            t.Key("linked_dataset_id"):  t.String(),
            t.Key("linked_features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("modification_date"):  t.DateTime(),
            t.Key("modified_by"):  t.String(),
            t.Key("source_dataset_id"):  t.String(),
            t.Key("source_features"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_by,
        creation_date,
        id,
        linked_dataset_id,
        linked_features,
        modification_date,
        modified_by,
        source_dataset_id,
        source_features,
    ):
        self.created_by = created_by
        self.creation_date = creation_date
        self.id = id
        self.linked_dataset_id = linked_dataset_id
        self.linked_features = linked_features
        self.modification_date = modification_date
        self.modified_by = modified_by
        self.source_dataset_id = source_dataset_id
        self.source_features = source_features

    def __repr__(self):
        return (
            "DatasetRelationshipResponse("
            "created_by={0.created_by}, "
            "creation_date={0.creation_date}, "
            "id={0.id}, "
            "linked_dataset_id={0.linked_dataset_id}, "
            "linked_features={0.linked_features}, "
            "modification_date={0.modification_date}, "
            "modified_by={0.modified_by}, "
            "source_dataset_id={0.source_dataset_id}, "
            "source_features={0.source_features}, "
        ).format(self)
