#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetRelationshipUpdate(APIObject):
    """
    Attributes
    ----------
    linked_dataset_id:str [optional]
         id of another dataset with which to create relationships. 
    linked_features:[str] [optional]
         list of features belonging to the linked dataset. 
    source_features:[str] [optional]
         list of features belonging to the source dataset. 
    """
    _converter = t.Dict(
        {
            t.Key("linked_dataset_id", optional=True):  t.String(),
            t.Key("linked_features", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("source_features", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        linked_dataset_id=None,
        linked_features=None,
        source_features=None,
    ):
        self.linked_dataset_id = linked_dataset_id
        self.linked_features = linked_features
        self.source_features = source_features

    def __repr__(self):
        return (
            "DatasetRelationshipUpdate("
            "linked_dataset_id={0.linked_dataset_id}, "
            "linked_features={0.linked_features}, "
            "source_features={0.source_features}, "
        ).format(self)
