#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetRolesWithId(APIObject):
    """
    Attributes
    ----------
    id:str
         The org/group/user ID.
    role:str
         The role of the org/group/user on this dataset or \"NO_ROLE\" for removing access when used with route to modify access.
    share_recipient_type:str
         It describes the recipient type.
    can_share:bool [optional]
         Whether the org/group/user should be able to share with others. If true, the org/group/user will be able to grant any role up to and including their own to other orgs/groups/user. If `role` is `NO_ROLE` `canShare` is ignored..  if omitted the server will use the default value of False
    can_use_data:bool [optional]
         Whether the user/group/org should be able to view, download and process data (use to create projects, predictions, etc). For OWNER `canUseData` is always True. If `role` is empty `canUseData` is ignored.. 
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("role"):  t.String(),
            t.Key("share_recipient_type"):  t.String(),
            t.Key("can_share", optional=True):  t.Bool(),
            t.Key("can_use_data", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        role,
        share_recipient_type,
        can_share=None,
        can_use_data=None,
    ):
        self.id = id
        self.role = role
        self.share_recipient_type = share_recipient_type
        self.can_share = can_share
        self.can_use_data = can_use_data

    def __repr__(self):
        return (
            "DatasetRolesWithId("
            "id={0.id}, "
            "role={0.role}, "
            "share_recipient_type={0.share_recipient_type}, "
            "can_share={0.can_share}, "
            "can_use_data={0.can_use_data}, "
        ).format(self)
