#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetTransformResponse(APIObject):
    """
    Attributes
    ----------
    date_extraction:str, none_type
         The value to extract from the date column.
    name:str
         The feature name.
    parent_name:str
         The name of the parent feature.
    replacement:bool, date, datetime, dict, float, int, list, str, none_type
         The replacement in case of a failed transformation.
    variable_type:str
         The type of the transform.
    """
    _converter = t.Dict(
        {
            t.Key("date_extraction"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("parent_name"):  t.String(),
            t.Key("replacement"):  t.Any(),
            t.Key("variable_type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        date_extraction,
        name,
        parent_name,
        replacement,
        variable_type,
    ):
        self.date_extraction = date_extraction
        self.name = name
        self.parent_name = parent_name
        self.replacement = replacement
        self.variable_type = variable_type

    def __repr__(self):
        return (
            "DatasetTransformResponse("
            "date_extraction={0.date_extraction}, "
            "name={0.name}, "
            "parent_name={0.parent_name}, "
            "replacement={0.replacement}, "
            "variable_type={0.variable_type}, "
        ).format(self)
