#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatasetsCredential(APIObject):
    """
    Attributes
    ----------
    catalog_version_id:str
         ID of the catalog version
    credential_id:str
         ID of the credential store to be used for the given catalog version
    url:str, none_type [optional]
         The URL of the datasource. 
    """
    _converter = t.Dict(
        {
            t.Key("catalog_version_id"):  t.String(),
            t.Key("credential_id"):  t.String(),
            t.Key("url", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_version_id,
        credential_id,
        url=None,
    ):
        self.catalog_version_id = catalog_version_id
        self.credential_id = credential_id
        self.url = url

    def __repr__(self):
        return (
            "DatasetsCredential("
            "catalog_version_id={0.catalog_version_id}, "
            "credential_id={0.credential_id}, "
            "url={0.url}, "
        ).format(self)
