#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Datasource(APIObject):
    """
    Attributes
    ----------
    data_source_id:str
         The identifier for the DataSource to use as the source of data.
    categories:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         An array of strings describing the intended use of the dataset.. 
    credential_data:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The credentials to authenticate with the database, to be used instead of credential ID.. 
    credential_id:str [optional]
         The ID of the set of credentials to authenticate with the database.. 
    do_snapshot:bool [optional]
         If true, create a snapshot dataset; if false, create a remote dataset. Creating snapshots from non-file sources requires an additional permission, `Enable Create Snapshot Data Source`..  if omitted the server will use the default value of True
    password:str [optional]
         The password (in cleartext) for database authentication. The password will be encrypted on the server side in scope of HTTP request and never saved or stored. DEPRECATED: please use credentialId or credentialData instead.. 
    persist_data_after_ingestion:bool [optional]
         If true, will enforce saving all data (for download and sampling) and will allow a user to view extended data profile (which includes data statistics like min/max/median/mean, histogram, etc.). If false, will not enforce saving data. The data schema (feature names and types) still will be available. Specifying this parameter to false and `doSnapshot` to true will result in an error.. 
    use_kerberos:bool [optional]
         If true, use kerberos authentication for database authentication..  if omitted the server will use the default value of False
    user:str [optional]
         The username for database authentication. DEPRECATED: please use credentialId or credentialData instead.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_source_id"):  t.String(),
            t.Key("categories", optional=True):  t.Any(),
            t.Key("credential_data", optional=True):  t.Any(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("do_snapshot", optional=True):  t.Bool(),
            t.Key("password", optional=True):  t.String(),
            t.Key("persist_data_after_ingestion", optional=True):  t.Bool(),
            t.Key("use_kerberos", optional=True):  t.Bool(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_source_id,
        categories=None,
        credential_data=None,
        credential_id=None,
        do_snapshot=None,
        password=None,
        persist_data_after_ingestion=None,
        use_kerberos=None,
        user=None,
    ):
        self.data_source_id = data_source_id
        self.categories = categories
        self.credential_data = credential_data
        self.credential_id = credential_id
        self.do_snapshot = do_snapshot
        self.password = password
        self.persist_data_after_ingestion = persist_data_after_ingestion
        self.use_kerberos = use_kerberos
        self.user = user

    def __repr__(self):
        return (
            "Datasource("
            "data_source_id={0.data_source_id}, "
            "categories={0.categories}, "
            "credential_data={0.credential_data}, "
            "credential_id={0.credential_id}, "
            "do_snapshot={0.do_snapshot}, "
            "password={0.password}, "
            "persist_data_after_ingestion={0.persist_data_after_ingestion}, "
            "use_kerberos={0.use_kerberos}, "
            "user={0.user}, "
        ).format(self)
