#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.backtest_status_response import BacktestStatusResponse
from datarobot.models.full_api.generated.model.training_info_response import TrainingInfoResponse

class DatetimeModelDetailsResponse(APIObject):
    """
    Attributes
    ----------
    backtests:[BacktestStatusResponse]
         information on each backtesting fold of the model
    blueprint_id:str
         the blueprint used to construct the model
    data_selection_method:str
         Identifies which setting defines the training size of the model when making predictions and scoring.
    effective_feature_derivation_window_end:int
         Only available for time series projects. How many timeUnits into the past relative to the forecast point the feature derivation window should end.
    effective_feature_derivation_window_start:int
         Only available for time series projects. How many timeUnits into the past relative to the forecast point the user needs to provide history for at prediction time. This can differ from the `featureDerivationWindowStart` set on the project due to the differencing method and period selected, or if the model is a time series native model such as ARIMA.
    featurelist_id:str, none_type
         the ID of the featurelist used by the model
    featurelist_name:str
         the name of the featurelist used by the model
    forecast_window_end:int
         Only available for time series projects. How many timeUnits into the future relative to the forecast point the forecast window should end.
    forecast_window_start:int
         Only available for time series projects. How many timeUnits into the future relative to the forecast point the forecast window should start.
    holdout_score:float, none_type
         the holdout score of the model according to the project metric, if the score is available and the holdout is unlocked
    holdout_status:str
         the status of the holdout fold
    id:str
         the ID of the model
    is_frozen:bool
         indicating whether the model is frozen, i.e. uses tuning parameters from a parent model
    is_starred:bool
         whether the model has been starred
    link_function:str, none_type
         the link function the final modeler uses in the blueprint. If no link function exists, returns null
    metrics:{str: (bool, date, datetime, dict, float, int, list, str, none_type)}
         Object where each metric has validation, backtesting, backtestingScores and holdout scores reported, or null if they have not been computed. The `validation` score will be the score of the first backtest, which will be computed during initial model training.  The `backtesting` and  `backtestingScores` scores are computed when requested via :http:post:`/api/v2/projects/(projectId)/datetimeModels/(modelId)/backtests/`. The `backtesting` score is the average score across all backtests. The `backtestingScores` is an array of scores for each backtest, with the scores reported as null if the backtest score is unavailable. The `holdout` score is the score against the holdout data, using the training data defined in `trainingInfo`.
    model_category:str
         indicates what kind of model it is - will be `prime` for DataRobot Prime models, `blend` for blender models, `scaleout` for scaleout models, and `model` for all other models
    model_family:str
         the family model belongs to, e.g. SVM, GMB, etc.
    model_number:int
         number of the model on leaderboard.
    model_type:str
         identifies the model, e.g. `Nystroem Kernel SVM Regressor`
    monotonic_decreasing_featurelist_id:str, none_type
         the ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target. If null, no such constraints are enforced.
    monotonic_increasing_featurelist_id:str, none_type
         the ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If null, no such constraints are enforced.
    parent_model_id:str, none_type
         if this model is frozen, this is the ID of the parent model. Otherwise Null.
    prediction_threshold:float
         threshold used for binary classification in predictions.
    prediction_threshold_read_only:bool
         indicates whether modification of a predictions threshold is forbidden. Since v2.22 threshold modification is allowed.
    processes:[str]
         list of processes used by the model
    project_id:str
         the ID of the project to which the model belongs
    sample_pct:str
         always null for datetime models
    supports_composable_ml:bool
         indicates whether this model is supported in Composable ML.
    supports_monotonic_constraints:bool
         whether this model supports enforcing monotonic constraints
    time_window_sample_pct:int, none_type
         An integer between 1 and 99, indicating the percentage of sampling within the time window. The points kept are determined by samplingMethod option. Will be null if no sampling was specified.
    training_duration:str, none_type
         the duration spanned by the dates in the partition column for the data used to train the model
    training_end_date:datetime, none_type
         the end date of the dates in the partition column for the data used to train the model
    training_info:TrainingInfoResponse
        
    training_row_count:int, none_type
         the number of rows used to train the model
    training_start_date:datetime, none_type
         the start date of the dates in the partition column for the data used to train the model
    windows_basis_unit:str
         Only available for time series projects. Indicates which unit is the basis for the feature derivation window and the forecast window.
    sampling_method:str [optional]
         indicates sampling method used to select training data. For row-based project this is the way how requested number of rows are selected.For other projects (duration-based, start/end, project settings) - how specified percent of rows (timeWindowSamplePct) is selected from specified time window.. 
    """
    _converter = t.Dict(
        {
            t.Key("backtests"):  t.List(t.Dict().allow_extra("*")),
            t.Key("blueprint_id"):  t.String(),
            t.Key("data_selection_method"):  t.String(),
            t.Key("effective_feature_derivation_window_end"):  t.Int(),
            t.Key("effective_feature_derivation_window_start"):  t.Int(),
            t.Key("featurelist_id"):  t.String(),
            t.Key("featurelist_name"):  t.String(),
            t.Key("forecast_window_end"):  t.Int(),
            t.Key("forecast_window_start"):  t.Int(),
            t.Key("holdout_score"):  t.Float(),
            t.Key("holdout_status"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_frozen"):  t.Bool(),
            t.Key("is_starred"):  t.Bool(),
            t.Key("link_function"):  t.String(),
            t.Key("metrics"):  t.Any(),
            t.Key("model_category"):  t.String(),
            t.Key("model_family"):  t.String(),
            t.Key("model_number"):  t.Int(),
            t.Key("model_type"):  t.String(),
            t.Key("monotonic_decreasing_featurelist_id"):  t.String(),
            t.Key("monotonic_increasing_featurelist_id"):  t.String(),
            t.Key("parent_model_id"):  t.String(),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("prediction_threshold_read_only"):  t.Bool(),
            t.Key("processes"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
            t.Key("sample_pct"):  t.String(),
            t.Key("supports_composable_ml"):  t.Bool(),
            t.Key("supports_monotonic_constraints"):  t.Bool(),
            t.Key("time_window_sample_pct"):  t.Int(),
            t.Key("training_duration"):  t.String(),
            t.Key("training_end_date"):  t.DateTime(),
            t.Key("training_info"):  t.Any(),
            t.Key("training_row_count"):  t.Int(),
            t.Key("training_start_date"):  t.DateTime(),
            t.Key("windows_basis_unit"):  t.String(),
            t.Key("sampling_method", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtests,
        blueprint_id,
        data_selection_method,
        effective_feature_derivation_window_end,
        effective_feature_derivation_window_start,
        featurelist_id,
        featurelist_name,
        forecast_window_end,
        forecast_window_start,
        holdout_score,
        holdout_status,
        id,
        is_frozen,
        is_starred,
        link_function,
        metrics,
        model_category,
        model_family,
        model_number,
        model_type,
        monotonic_decreasing_featurelist_id,
        monotonic_increasing_featurelist_id,
        parent_model_id,
        prediction_threshold,
        prediction_threshold_read_only,
        processes,
        project_id,
        sample_pct,
        supports_composable_ml,
        supports_monotonic_constraints,
        time_window_sample_pct,
        training_duration,
        training_end_date,
        training_info,
        training_row_count,
        training_start_date,
        windows_basis_unit,
        sampling_method=None,
    ):
        self.backtests = backtests
        self.blueprint_id = blueprint_id
        self.data_selection_method = data_selection_method
        self.effective_feature_derivation_window_end = effective_feature_derivation_window_end
        self.effective_feature_derivation_window_start = effective_feature_derivation_window_start
        self.featurelist_id = featurelist_id
        self.featurelist_name = featurelist_name
        self.forecast_window_end = forecast_window_end
        self.forecast_window_start = forecast_window_start
        self.holdout_score = holdout_score
        self.holdout_status = holdout_status
        self.id = id
        self.is_frozen = is_frozen
        self.is_starred = is_starred
        self.link_function = link_function
        self.metrics = metrics
        self.model_category = model_category
        self.model_family = model_family
        self.model_number = model_number
        self.model_type = model_type
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.parent_model_id = parent_model_id
        self.prediction_threshold = prediction_threshold
        self.prediction_threshold_read_only = prediction_threshold_read_only
        self.processes = processes
        self.project_id = project_id
        self.sample_pct = sample_pct
        self.supports_composable_ml = supports_composable_ml
        self.supports_monotonic_constraints = supports_monotonic_constraints
        self.time_window_sample_pct = time_window_sample_pct
        self.training_duration = training_duration
        self.training_end_date = training_end_date
        self.training_info = training_info
        self.training_row_count = training_row_count
        self.training_start_date = training_start_date
        self.windows_basis_unit = windows_basis_unit
        self.sampling_method = sampling_method

    def __repr__(self):
        return (
            "DatetimeModelDetailsResponse("
            "backtests={0.backtests}, "
            "blueprint_id={0.blueprint_id}, "
            "data_selection_method={0.data_selection_method}, "
            "effective_feature_derivation_window_end={0.effective_feature_derivation_window_end}, "
            "effective_feature_derivation_window_start={0.effective_feature_derivation_window_start}, "
            "featurelist_id={0.featurelist_id}, "
            "featurelist_name={0.featurelist_name}, "
            "forecast_window_end={0.forecast_window_end}, "
            "forecast_window_start={0.forecast_window_start}, "
            "holdout_score={0.holdout_score}, "
            "holdout_status={0.holdout_status}, "
            "id={0.id}, "
            "is_frozen={0.is_frozen}, "
            "is_starred={0.is_starred}, "
            "link_function={0.link_function}, "
            "metrics={0.metrics}, "
            "model_category={0.model_category}, "
            "model_family={0.model_family}, "
            "model_number={0.model_number}, "
            "model_type={0.model_type}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "parent_model_id={0.parent_model_id}, "
            "prediction_threshold={0.prediction_threshold}, "
            "prediction_threshold_read_only={0.prediction_threshold_read_only}, "
            "processes={0.processes}, "
            "project_id={0.project_id}, "
            "sample_pct={0.sample_pct}, "
            "supports_composable_ml={0.supports_composable_ml}, "
            "supports_monotonic_constraints={0.supports_monotonic_constraints}, "
            "time_window_sample_pct={0.time_window_sample_pct}, "
            "training_duration={0.training_duration}, "
            "training_end_date={0.training_end_date}, "
            "training_info={0.training_info}, "
            "training_row_count={0.training_row_count}, "
            "training_start_date={0.training_start_date}, "
            "windows_basis_unit={0.windows_basis_unit}, "
            "sampling_method={0.sampling_method}, "
        ).format(self)
