#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.datetime_model_details_response import DatetimeModelDetailsResponse

class DatetimeModelsResponse(APIObject):
    """
    Attributes
    ----------
    data:[DatetimeModelDetailsResponse]
         each has the same schema as if retrieving the model individually from :http:get:`/api/v2/projects/(projectId)/datetimeModels/(modelId)/`.
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    count:int [optional]
         Number of items returned on this page.. 
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        next,
        previous,
        count=None,
    ):
        self.data = data
        self.next = next
        self.previous = previous
        self.count = count

    def __repr__(self):
        return (
            "DatetimeModelsResponse("
            "data={0.data}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "count={0.count}, "
        ).format(self)
