#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DatetimeTrendPlotsCreate(APIObject):
    """
    Attributes
    ----------
    backtest:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Compute plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. 
    forecast_distance_end:int [optional]
         The end of forecast distance range (forecast window) to compute. If not specified, the last forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. 
    forecast_distance_start:int [optional]
         The start of forecast distance range (forecast window) to compute. If not specified, the first forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. 
    source:str [optional]
         The source of the data for the backtest/holdout..  if omitted the server will use the default value of "validation"
    """
    _converter = t.Dict(
        {
            t.Key("backtest", optional=True):  t.Any(),
            t.Key("forecast_distance_end", optional=True):  t.Int(),
            t.Key("forecast_distance_start", optional=True):  t.Int(),
            t.Key("source", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest=None,
        forecast_distance_end=None,
        forecast_distance_start=None,
        source=None,
    ):
        self.backtest = backtest
        self.forecast_distance_end = forecast_distance_end
        self.forecast_distance_start = forecast_distance_start
        self.source = source

    def __repr__(self):
        return (
            "DatetimeTrendPlotsCreate("
            "backtest={0.backtest}, "
            "forecast_distance_end={0.forecast_distance_end}, "
            "forecast_distance_start={0.forecast_distance_start}, "
            "source={0.source}, "
        ).format(self)
