#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.datetime_trend_plots_preview_bins import DatetimeTrendPlotsPreviewBins

class DatetimeTrendPlotsPreviewResponse(APIObject):
    """
    Attributes
    ----------
    bins:[DatetimeTrendPlotsPreviewBins]
         An array of bins for the retrieved plots.
    end_date:datetime
         The datetime of the end of the chart data (exclusive). 
    start_date:datetime
         The datetime of the start of the chart data (inclusive). 
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("end_date"):  t.DateTime(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        end_date,
        start_date,
    ):
        self.bins = bins
        self.end_date = end_date
        self.start_date = start_date

    def __repr__(self):
        return (
            "DatetimeTrendPlotsPreviewResponse("
            "bins={0.bins}, "
            "end_date={0.end_date}, "
            "start_date={0.start_date}, "
        ).format(self)
