#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeletedProjectCountResponse(APIObject):
    """
    Attributes
    ----------
    deleted_projects_count:int
         Amount of soft-deleted projects. The value is limited by projectCountLimit
    project_count_limit:int
         Deleted projects counting limit value. Stop counting above this limit
    value_exceeds_limit:bool
         If an actual number of soft-deleted projects exceeds counting limit
    """
    _converter = t.Dict(
        {
            t.Key("deleted_projects_count"):  t.Int(),
            t.Key("project_count_limit"):  t.Int(),
            t.Key("value_exceeds_limit"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        deleted_projects_count,
        project_count_limit,
        value_exceeds_limit,
    ):
        self.deleted_projects_count = deleted_projects_count
        self.project_count_limit = project_count_limit
        self.value_exceeds_limit = value_exceeds_limit

    def __repr__(self):
        return (
            "DeletedProjectCountResponse("
            "deleted_projects_count={0.deleted_projects_count}, "
            "project_count_limit={0.project_count_limit}, "
            "value_exceeds_limit={0.value_exceeds_limit}, "
        ).format(self)
