#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.deleted_project_organization import DeletedProjectOrganization
from datarobot.models.full_api.generated.model.deleted_project_user import DeletedProjectUser

class DeletedProjectResponse(APIObject):
    """
    Attributes
    ----------
    created_by:DeletedProjectUser
        
    deleted_by:DeletedProjectUser
        
    deletion_time:datetime, none_type
         ISO-8601 formatted date when project was deleted
    file_name:str, none_type
         The name of the file uploaded for the project dataset
    id:str
         The ID of the project
    organization:DeletedProjectOrganization
        
    project_name:str
         The name of the project. defaults to "Untitled Project"
    scheduled_for_deletion:bool
         Whether project permanent deletion has already been scheduled
    """
    _converter = t.Dict(
        {
            t.Key("created_by"):  t.Any(),
            t.Key("deleted_by"):  t.Any(),
            t.Key("deletion_time"):  t.DateTime(),
            t.Key("file_name"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("organization"):  t.Any(),
            t.Key("project_name"):  t.String(),
            t.Key("scheduled_for_deletion"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_by,
        deleted_by,
        deletion_time,
        file_name,
        id,
        organization,
        project_name,
        scheduled_for_deletion,
    ):
        self.created_by = created_by
        self.deleted_by = deleted_by
        self.deletion_time = deletion_time
        self.file_name = file_name
        self.id = id
        self.organization = organization
        self.project_name = project_name
        self.scheduled_for_deletion = scheduled_for_deletion

    def __repr__(self):
        return (
            "DeletedProjectResponse("
            "created_by={0.created_by}, "
            "deleted_by={0.deleted_by}, "
            "deletion_time={0.deletion_time}, "
            "file_name={0.file_name}, "
            "id={0.id}, "
            "organization={0.organization}, "
            "project_name={0.project_name}, "
            "scheduled_for_deletion={0.scheduled_for_deletion}, "
        ).format(self)
