#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DemoApplication(APIObject):
    """
    Attributes
    ----------
    application_type_id:str
         The ID of the application to be created
    usecase_id:str, none_type [optional]
         The ID of the use case to use for the demo application. 
    """
    _converter = t.Dict(
        {
            t.Key("application_type_id"):  t.String(),
            t.Key("usecase_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        application_type_id,
        usecase_id=None,
    ):
        self.application_type_id = application_type_id
        self.usecase_id = usecase_id

    def __repr__(self):
        return (
            "DemoApplication("
            "application_type_id={0.application_type_id}, "
            "usecase_id={0.usecase_id}, "
        ).format(self)
