#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dependency_constraint import DependencyConstraint

class DependencyResponse(APIObject):
    """
    Attributes
    ----------
    constraints:[DependencyConstraint]
         Constraints that should be applied to the dependency when installed.
    line:str
         The original line from the requirements.txt file.
    line_number:int
         The line number the requirement was on in requirements.txt.
    package_name:str
         The dependency's package name.
    """
    _converter = t.Dict(
        {
            t.Key("constraints"):  t.List(t.Dict().allow_extra("*")),
            t.Key("line"):  t.String(),
            t.Key("line_number"):  t.Int(),
            t.Key("package_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        constraints,
        line,
        line_number,
        package_name,
    ):
        self.constraints = constraints
        self.line = line
        self.line_number = line_number
        self.package_name = package_name

    def __repr__(self):
        return (
            "DependencyResponse("
            "constraints={0.constraints}, "
            "line={0.line}, "
            "line_number={0.line_number}, "
            "package_name={0.package_name}, "
        ).format(self)
