#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentAccuracyHealthResponse(APIObject):
    """
    Attributes
    ----------
    end_date:datetime, none_type
         End date of accuracy health period.
    message:str
         A message providing more detail on the status.
    start_date:datetime, none_type
         Start date of accuracy health period.
    status:str
         Accuracy health status.
    """
    _converter = t.Dict(
        {
            t.Key("end_date"):  t.DateTime(),
            t.Key("message"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
            t.Key("status"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        end_date,
        message,
        start_date,
        status,
    ):
        self.end_date = end_date
        self.message = message
        self.start_date = start_date
        self.status = status

    def __repr__(self):
        return (
            "DeploymentAccuracyHealthResponse("
            "end_date={0.end_date}, "
            "message={0.message}, "
            "start_date={0.start_date}, "
            "status={0.status}, "
        ).format(self)
