#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.actual import Actual

class DeploymentActuals(APIObject):
    """
    Attributes
    ----------
    data:[Actual]
         A list of `actual` objects that describes actual values. Minimum size of the list is 1 and maximum size is 10000 items. An `actual` object has the following schema.
    keep_actuals_without_predictions:bool [optional]
         Indicates if actual without predictions are kept..  if omitted the server will use the default value of True
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("keep_actuals_without_predictions", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        keep_actuals_without_predictions=None,
    ):
        self.data = data
        self.keep_actuals_without_predictions = keep_actuals_without_predictions

    def __repr__(self):
        return (
            "DeploymentActuals("
            "data={0.data}, "
            "keep_actuals_without_predictions={0.keep_actuals_without_predictions}, "
        ).format(self)
