#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentCapabilitiesResponse(APIObject):
    """
    Attributes
    ----------
    supports_challenger_models:bool
         If the deployment supports challenger models.
    supports_feature_drift_tracking:bool
         If the deployment supports feature drift tracking.
    supports_humility_recommended_rules:bool
         If the deployment supports calculating values for humility recommended rules.
    supports_humility_rules:bool
         If the deployment supports humble ai.
    supports_humility_rules_default_calculations:bool
         If the deployment supports calculating default values for humility rules.
    supports_model_replacement:bool
         If the deployment supports model replacement.
    supports_prediction_intervals:bool
         if the deployment supports prediction intervals.
    supports_prediction_warning:bool
         If the deployment supports prediction warnings.
    supports_target_drift_tracking:bool
         If the deployment supports target drift tracking.
    supports_automatic_actuals:bool [optional]
         With this feature enabled, DataRobot infers actual values from time series history data and automatically feeds them back for accuracy estimation.. 
    supports_portable_prediction_server:bool [optional]
         If the deployment supports portable prediction servers. this enables to downloada dedicated model package to be deployed on external prediction environments. 
    supports_scoring_code_download:bool [optional]
         If the currently deployed model supports scoring code download.. 
    supports_segmented_analysis_drift_and_accuracy:bool [optional]
         If the deployment supports tracking features in training and predictions data for segmented analysis of drift and accuracy.. 
    supports_shap_based_prediction_explanations:bool [optional]
         If the currently deployed model supports shap based prediction explanations.. 
    """
    _converter = t.Dict(
        {
            t.Key("supports_challenger_models"):  t.Bool(),
            t.Key("supports_feature_drift_tracking"):  t.Bool(),
            t.Key("supports_humility_recommended_rules"):  t.Bool(),
            t.Key("supports_humility_rules"):  t.Bool(),
            t.Key("supports_humility_rules_default_calculations"):  t.Bool(),
            t.Key("supports_model_replacement"):  t.Bool(),
            t.Key("supports_prediction_intervals"):  t.Bool(),
            t.Key("supports_prediction_warning"):  t.Bool(),
            t.Key("supports_target_drift_tracking"):  t.Bool(),
            t.Key("supports_automatic_actuals", optional=True):  t.Bool(),
            t.Key("supports_portable_prediction_server", optional=True):  t.Bool(),
            t.Key("supports_scoring_code_download", optional=True):  t.Bool(),
            t.Key("supports_segmented_analysis_drift_and_accuracy", optional=True):  t.Bool(),
            t.Key("supports_shap_based_prediction_explanations", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        supports_challenger_models,
        supports_feature_drift_tracking,
        supports_humility_recommended_rules,
        supports_humility_rules,
        supports_humility_rules_default_calculations,
        supports_model_replacement,
        supports_prediction_intervals,
        supports_prediction_warning,
        supports_target_drift_tracking,
        supports_automatic_actuals=None,
        supports_portable_prediction_server=None,
        supports_scoring_code_download=None,
        supports_segmented_analysis_drift_and_accuracy=None,
        supports_shap_based_prediction_explanations=None,
    ):
        self.supports_challenger_models = supports_challenger_models
        self.supports_feature_drift_tracking = supports_feature_drift_tracking
        self.supports_humility_recommended_rules = supports_humility_recommended_rules
        self.supports_humility_rules = supports_humility_rules
        self.supports_humility_rules_default_calculations = supports_humility_rules_default_calculations
        self.supports_model_replacement = supports_model_replacement
        self.supports_prediction_intervals = supports_prediction_intervals
        self.supports_prediction_warning = supports_prediction_warning
        self.supports_target_drift_tracking = supports_target_drift_tracking
        self.supports_automatic_actuals = supports_automatic_actuals
        self.supports_portable_prediction_server = supports_portable_prediction_server
        self.supports_scoring_code_download = supports_scoring_code_download
        self.supports_segmented_analysis_drift_and_accuracy = supports_segmented_analysis_drift_and_accuracy
        self.supports_shap_based_prediction_explanations = supports_shap_based_prediction_explanations

    def __repr__(self):
        return (
            "DeploymentCapabilitiesResponse("
            "supports_challenger_models={0.supports_challenger_models}, "
            "supports_feature_drift_tracking={0.supports_feature_drift_tracking}, "
            "supports_humility_recommended_rules={0.supports_humility_recommended_rules}, "
            "supports_humility_rules={0.supports_humility_rules}, "
            "supports_humility_rules_default_calculations={0.supports_humility_rules_default_calculations}, "
            "supports_model_replacement={0.supports_model_replacement}, "
            "supports_prediction_intervals={0.supports_prediction_intervals}, "
            "supports_prediction_warning={0.supports_prediction_warning}, "
            "supports_target_drift_tracking={0.supports_target_drift_tracking}, "
            "supports_automatic_actuals={0.supports_automatic_actuals}, "
            "supports_portable_prediction_server={0.supports_portable_prediction_server}, "
            "supports_scoring_code_download={0.supports_scoring_code_download}, "
            "supports_segmented_analysis_drift_and_accuracy={0.supports_segmented_analysis_drift_and_accuracy}, "
            "supports_shap_based_prediction_explanations={0.supports_shap_based_prediction_explanations}, "
        ).format(self)
