#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentCreateFromLearningModel(APIObject):
    """
    Attributes
    ----------
    description:str, none_type
         A description for the deployment.. defaults to "null"
    label:str
         A human-readable name for the deployment.
    model_id:str
         The ID of the deployment.
    default_prediction_server_id:str [optional]
         ID of the default prediction server for deployment. Required for DataRobot Cloud, must be omitted for Enterprise installations.. 
    importance:str [optional]
         Used only when `Model Deployment Approvals Workflow` is enabled. The parameter to show how important the deployment is. If `Model Deployment Approvals Workflow` is enabled and ``materiality`` is not specified defaults to ``MODERATE``.. 
    prediction_threshold:float [optional]
         Prediction threshold used for binary classification. If not specified, model default prediction threshold will be used.. 
    status:str, none_type [optional]
         Status of the deployment.  if omitted the server will use the default value of "active"
    """
    _converter = t.Dict(
        {
            t.Key("description"):  t.String(),
            t.Key("label"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("default_prediction_server_id", optional=True):  t.String(),
            t.Key("importance", optional=True):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("status", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description,
        label,
        model_id,
        default_prediction_server_id=None,
        importance=None,
        prediction_threshold=None,
        status=None,
    ):
        self.description = description
        self.label = label
        self.model_id = model_id
        self.default_prediction_server_id = default_prediction_server_id
        self.importance = importance
        self.prediction_threshold = prediction_threshold
        self.status = status

    def __repr__(self):
        return (
            "DeploymentCreateFromLearningModel("
            "description={0.description}, "
            "label={0.label}, "
            "model_id={0.model_id}, "
            "default_prediction_server_id={0.default_prediction_server_id}, "
            "importance={0.importance}, "
            "prediction_threshold={0.prediction_threshold}, "
            "status={0.status}, "
        ).format(self)
