#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentCreateFromProjectRecommendedModel(APIObject):
    """
    Attributes
    ----------
    description:str, none_type
         A description for the deployment.. defaults to "null"
    label:str
         A human-readable name for the deployment.
    project_id:str
         ID of the project entry to deploy recommended model from.
    default_prediction_server_id:str [optional]
         ID of the default prediction server for deployment. Required for DataRobot Cloud, must be omitted for Enterprise installations.. 
    importance:str [optional]
         Used only when `Model Deployment Approvals Workflow` is enabled. The parameter to show how important the deployment is. If `Model Deployment Approvals Workflow` is enabled and ``materiality`` is not specified defaults to ``MODERATE``.. 
    """
    _converter = t.Dict(
        {
            t.Key("description"):  t.String(),
            t.Key("label"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("default_prediction_server_id", optional=True):  t.String(),
            t.Key("importance", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description,
        label,
        project_id,
        default_prediction_server_id=None,
        importance=None,
    ):
        self.description = description
        self.label = label
        self.project_id = project_id
        self.default_prediction_server_id = default_prediction_server_id
        self.importance = importance

    def __repr__(self):
        return (
            "DeploymentCreateFromProjectRecommendedModel("
            "description={0.description}, "
            "label={0.label}, "
            "project_id={0.project_id}, "
            "default_prediction_server_id={0.default_prediction_server_id}, "
            "importance={0.importance}, "
        ).format(self)
