#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentDatasetCreate(APIObject):
    """
    Attributes
    ----------
    actual_value_column:str
         Column name that contains actual values.
    association_id_column:str
         Column name that contains unique identifiers used with a predicted rows.
    dataset_id:str
         The ID of dataset from catalog.
    dataset_version_id:str, none_type [optional]
         Version of dataset to retrieve.. 
    keep_actuals_without_predictions:bool [optional]
         Indicates if actual without predictions are kept..  if omitted the server will use the default value of True
    password:str [optional]
         The password for database authentication.. 
    timestamp_column:str [optional]
         Column name that contain datetime when actual values were obtained.. 
    user:str [optional]
         The username for database authentication.. 
    was_acted_on_column:str [optional]
         Column name that contains boolean values if any action was made based on predictions data.. 
    """
    _converter = t.Dict(
        {
            t.Key("actual_value_column"):  t.String(),
            t.Key("association_id_column"):  t.String(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
            t.Key("keep_actuals_without_predictions", optional=True):  t.Bool(),
            t.Key("password", optional=True):  t.String(),
            t.Key("timestamp_column", optional=True):  t.String(),
            t.Key("user", optional=True):  t.String(),
            t.Key("was_acted_on_column", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_value_column,
        association_id_column,
        dataset_id,
        dataset_version_id=None,
        keep_actuals_without_predictions=None,
        password=None,
        timestamp_column=None,
        user=None,
        was_acted_on_column=None,
    ):
        self.actual_value_column = actual_value_column
        self.association_id_column = association_id_column
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.keep_actuals_without_predictions = keep_actuals_without_predictions
        self.password = password
        self.timestamp_column = timestamp_column
        self.user = user
        self.was_acted_on_column = was_acted_on_column

    def __repr__(self):
        return (
            "DeploymentDatasetCreate("
            "actual_value_column={0.actual_value_column}, "
            "association_id_column={0.association_id_column}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "keep_actuals_without_predictions={0.keep_actuals_without_predictions}, "
            "password={0.password}, "
            "timestamp_column={0.timestamp_column}, "
            "user={0.user}, "
            "was_acted_on_column={0.was_acted_on_column}, "
        ).format(self)
