#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentFairnessHealthResponse(APIObject):
    """
    Attributes
    ----------
    end_date:datetime, none_type
         End date of fairness health period.
    influential_fairness_metric:str, none_type
         Fairness metric with the most failing classes
    message:str
         A tooltip explaining the fairness status.
    protected_features_count:int
         Count of the configured protected features for the deployment.
    start_date:datetime, none_type
         Start date of fairness health period.
    status:str
                      Overall status of the deployment health based of calculated fairness scores.                * ``unknown`` - used when the deployment fairness status was never calculated.               * ``passing`` - used when all fairness criteria are met.               * ``warning`` - used when certain criteria are not met                               but those are not critical for the user.                               It is an intermediate status between ``passing`` and ``failing``.               * ``failing`` - used when critical criteria are not met,                               indicating that the deployment is failing fairness checks.             
    """
    _converter = t.Dict(
        {
            t.Key("end_date"):  t.DateTime(),
            t.Key("influential_fairness_metric"):  t.String(),
            t.Key("message"):  t.String(),
            t.Key("protected_features_count"):  t.Int(),
            t.Key("start_date"):  t.DateTime(),
            t.Key("status"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        end_date,
        influential_fairness_metric,
        message,
        protected_features_count,
        start_date,
        status,
    ):
        self.end_date = end_date
        self.influential_fairness_metric = influential_fairness_metric
        self.message = message
        self.protected_features_count = protected_features_count
        self.start_date = start_date
        self.status = status

    def __repr__(self):
        return (
            "DeploymentFairnessHealthResponse("
            "end_date={0.end_date}, "
            "influential_fairness_metric={0.influential_fairness_metric}, "
            "message={0.message}, "
            "protected_features_count={0.protected_features_count}, "
            "start_date={0.start_date}, "
            "status={0.status}, "
        ).format(self)
