#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentFeatureDriftObject(APIObject):
    """
    Attributes
    ----------
    baseline_sample_size:int
         The sample size of the training data.
    drift_score:float, none_type
         The drift score for this feature.
    feature_impact:float
         The feature impact score for this feature.
    name:str
         The name of the feature.
    sample_size:int
         The number of predictions used to compute the drift score.
    """
    _converter = t.Dict(
        {
            t.Key("baseline_sample_size"):  t.Int(),
            t.Key("drift_score"):  t.Float(),
            t.Key("feature_impact"):  t.Float(),
            t.Key("name"):  t.String(),
            t.Key("sample_size"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        baseline_sample_size,
        drift_score,
        feature_impact,
        name,
        sample_size,
    ):
        self.baseline_sample_size = baseline_sample_size
        self.drift_score = drift_score
        self.feature_impact = feature_impact
        self.name = name
        self.sample_size = sample_size

    def __repr__(self):
        return (
            "DeploymentFeatureDriftObject("
            "baseline_sample_size={0.baseline_sample_size}, "
            "drift_score={0.drift_score}, "
            "feature_impact={0.feature_impact}, "
            "name={0.name}, "
            "sample_size={0.sample_size}, "
        ).format(self)
