#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.deployment_feature_drift_object import DeploymentFeatureDriftObject
from datarobot.models.full_api.generated.model.time_range import TimeRange

class DeploymentFeatureDriftResponse(APIObject):
    """
    Attributes
    ----------
    data:[DeploymentFeatureDriftObject]
         An array [DriftObject], each in the form described below
    model_id:str
         The id of the model for which the features drift is being retrieved.
    period:TimeRange
        
    count:int [optional]
         The number of items returned on this page.. 
    metric:str [optional]
         Metric used to calculate drift score.. 
    next:str, none_type [optional]
         A URL pointing to the next page (if null, there is no next page). 
    previous:str, none_type [optional]
         A URL pointing to the previous page (if null, there is no previous page). 
    segment_attribute:str, none_type [optional]
         The name of the segment on which segment analysis is being performed.. 
    segment_value:str, none_type [optional]
         The value of the `segmentAttribute` to segment on.. 
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("model_id"):  t.String(),
            t.Key("period"):  t.Any(),
            t.Key("count", optional=True):  t.Int(),
            t.Key("metric", optional=True):  t.String(),
            t.Key("next", optional=True):  t.String(),
            t.Key("previous", optional=True):  t.String(),
            t.Key("segment_attribute", optional=True):  t.String(),
            t.Key("segment_value", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        model_id,
        period,
        count=None,
        metric=None,
        next=None,
        previous=None,
        segment_attribute=None,
        segment_value=None,
    ):
        self.data = data
        self.model_id = model_id
        self.period = period
        self.count = count
        self.metric = metric
        self.next = next
        self.previous = previous
        self.segment_attribute = segment_attribute
        self.segment_value = segment_value

    def __repr__(self):
        return (
            "DeploymentFeatureDriftResponse("
            "data={0.data}, "
            "model_id={0.model_id}, "
            "period={0.period}, "
            "count={0.count}, "
            "metric={0.metric}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "segment_attribute={0.segment_attribute}, "
            "segment_value={0.segment_value}, "
        ).format(self)
