#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentGovernanceResponse(APIObject):
    """
    Attributes
    ----------
    approval_status:str
         Status to show whether the deployment was approved or not. It also shows up as a part of metadata within the prediction response.
    has_opened_change_requests:bool
         If there are change request related to this deployment with `PENDING` status.
    """
    _converter = t.Dict(
        {
            t.Key("approval_status"):  t.String(),
            t.Key("has_opened_change_requests"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        approval_status,
        has_opened_change_requests,
    ):
        self.approval_status = approval_status
        self.has_opened_change_requests = has_opened_change_requests

    def __repr__(self):
        return (
            "DeploymentGovernanceResponse("
            "approval_status={0.approval_status}, "
            "has_opened_change_requests={0.has_opened_change_requests}, "
        ).format(self)
