#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentModelResponse(APIObject):
    """
    Attributes
    ----------
    id:str
         ID of the current model.
    project_name:str, none_type
         Project name of the current model.
    target_name:str
         Target name of the current model.
    target_type:str
         Target type of the current model.
    type:str
         Type of the current model.
    unsupervised_mode:bool
         Whether the current model's project is unsupervised.
    build_environment_type:str, none_type [optional]
         Build environment type of the current model.. 
    decision_flow_id:str, none_type [optional]
         The ID of the decision flow if the deployment has one. . 
    decision_flow_version_id:str, none_type [optional]
         The ID of the decision flow version if the deployment has one. . 
    deployed_at:datetime, none_type [optional]
         Timestamp of when current model was deployed.. 
    has_automodel:bool, none_type [optional]
         Whether the deployment's current model has associated automodel. 
    has_decision_flow:bool [optional]
         True if this deployment contains a Decision Flow. 
    project_id:str, none_type [optional]
         Project ID of the current model.. 
    unsupervised_type:str, none_type [optional]
         Only valid when unsupervisedMode is True. The type of unsupervised project, anomaly or clustering. If unsupervisedMode, defaults to 'anomaly'.. 
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("project_name"):  t.String(),
            t.Key("target_name"):  t.String(),
            t.Key("target_type"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("unsupervised_mode"):  t.Bool(),
            t.Key("build_environment_type", optional=True):  t.String(),
            t.Key("decision_flow_id", optional=True):  t.String(),
            t.Key("decision_flow_version_id", optional=True):  t.String(),
            t.Key("deployed_at", optional=True):  t.DateTime(),
            t.Key("has_automodel", optional=True):  t.Bool(),
            t.Key("has_decision_flow", optional=True):  t.Bool(),
            t.Key("project_id", optional=True):  t.String(),
            t.Key("unsupervised_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        project_name,
        target_name,
        target_type,
        type,
        unsupervised_mode,
        build_environment_type=None,
        decision_flow_id=None,
        decision_flow_version_id=None,
        deployed_at=None,
        has_automodel=None,
        has_decision_flow=None,
        project_id=None,
        unsupervised_type=None,
    ):
        self.id = id
        self.project_name = project_name
        self.target_name = target_name
        self.target_type = target_type
        self.type = type
        self.unsupervised_mode = unsupervised_mode
        self.build_environment_type = build_environment_type
        self.decision_flow_id = decision_flow_id
        self.decision_flow_version_id = decision_flow_version_id
        self.deployed_at = deployed_at
        self.has_automodel = has_automodel
        self.has_decision_flow = has_decision_flow
        self.project_id = project_id
        self.unsupervised_type = unsupervised_type

    def __repr__(self):
        return (
            "DeploymentModelResponse("
            "id={0.id}, "
            "project_name={0.project_name}, "
            "target_name={0.target_name}, "
            "target_type={0.target_type}, "
            "type={0.type}, "
            "unsupervised_mode={0.unsupervised_mode}, "
            "build_environment_type={0.build_environment_type}, "
            "decision_flow_id={0.decision_flow_id}, "
            "decision_flow_version_id={0.decision_flow_version_id}, "
            "deployed_at={0.deployed_at}, "
            "has_automodel={0.has_automodel}, "
            "has_decision_flow={0.has_decision_flow}, "
            "project_id={0.project_id}, "
            "unsupervised_type={0.unsupervised_type}, "
        ).format(self)
