#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentPermanentDelete(APIObject):
    """
    Attributes
    ----------
    action:str
         Action to perform on these deleted deployments.. defaults to "PermanentlyErase", must be one of ["PermanentlyErase", ]
    deployment_ids:[str]
         ID of a list of deleted deployments to perform action on.
    """
    _converter = t.Dict(
        {
            t.Key("action"):  t.String(),
            t.Key("deployment_ids"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        action,
        deployment_ids,
    ):
        self.action = action
        self.deployment_ids = deployment_ids

    def __repr__(self):
        return (
            "DeploymentPermanentDelete("
            "action={0.action}, "
            "deployment_ids={0.deployment_ids}, "
        ).format(self)
