#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeploymentPredictionEnvironmentResponse(APIObject):
    """
    Attributes
    ----------
    id:str, none_type
         ID of the PredictionEnvironment.
    is_managed_by_management_agent:bool
         True if PredictionEnvironment is using Management Agent.
    name:str
         Name of the PredictionEnvironment.
    platform:str
         Platform of the PredictionEnvironment.
    plugin:str, none_type [optional]
         Plugin name of the PredictionEnvironment.. 
    supported_model_formats:[str] [optional]
         Model formats that the PredictionEnvironment supports.. 
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("is_managed_by_management_agent"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("platform"):  t.String(),
            t.Key("plugin", optional=True):  t.String(),
            t.Key("supported_model_formats", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        is_managed_by_management_agent,
        name,
        platform,
        plugin=None,
        supported_model_formats=None,
    ):
        self.id = id
        self.is_managed_by_management_agent = is_managed_by_management_agent
        self.name = name
        self.platform = platform
        self.plugin = plugin
        self.supported_model_formats = supported_model_formats

    def __repr__(self):
        return (
            "DeploymentPredictionEnvironmentResponse("
            "id={0.id}, "
            "is_managed_by_management_agent={0.is_managed_by_management_agent}, "
            "name={0.name}, "
            "platform={0.platform}, "
            "plugin={0.plugin}, "
            "supported_model_formats={0.supported_model_formats}, "
        ).format(self)
