#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.deployment_accuracy_health_response import DeploymentAccuracyHealthResponse
from datarobot.models.full_api.generated.model.deployment_capabilities_response import DeploymentCapabilitiesResponse
from datarobot.models.full_api.generated.model.deployment_default_prediction_server_response import DeploymentDefaultPredictionServerResponse
from datarobot.models.full_api.generated.model.deployment_governance_response import DeploymentGovernanceResponse
from datarobot.models.full_api.generated.model.deployment_model_health_response import DeploymentModelHealthResponse
from datarobot.models.full_api.generated.model.deployment_model_package_initial_download_response import DeploymentModelPackageInitialDownloadResponse
from datarobot.models.full_api.generated.model.deployment_model_package_response import DeploymentModelPackageResponse
from datarobot.models.full_api.generated.model.deployment_model_response import DeploymentModelResponse
from datarobot.models.full_api.generated.model.deployment_owners_response import DeploymentOwnersResponse
from datarobot.models.full_api.generated.model.deployment_prediction_environment_response import DeploymentPredictionEnvironmentResponse
from datarobot.models.full_api.generated.model.deployment_prediction_usage_response import DeploymentPredictionUsageResponse
from datarobot.models.full_api.generated.model.deployment_scoring_code_initial_download_response import DeploymentScoringCodeInitialDownloadResponse
from datarobot.models.full_api.generated.model.deployment_service_health_response import DeploymentServiceHealthResponse
from datarobot.models.full_api.generated.model.deployment_settings_info import DeploymentSettingsInfo

class DeploymentRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    accuracy_health:DeploymentAccuracyHealthResponse
        
    capabilities:DeploymentCapabilitiesResponse
        
    created_at:datetime
         The date and time of when the deployment was created, in ISO 8601 format.
    default_prediction_server:DeploymentDefaultPredictionServerResponse
        
    description:str, none_type
         Description of the deployment.
    id:str
         ID of the deployment.
    label:str
         Label of the deployment.
    model:DeploymentModelResponse
        
    model_health:DeploymentModelHealthResponse
        
    permissions:[str]
         Permissions of the user making the request has on the deployment.
    prediction_usage:DeploymentPredictionUsageResponse
        
    service_health:DeploymentServiceHealthResponse
        
    settings:DeploymentSettingsInfo
        
    status:str
         Displays current deployment status.
    approval_status:str [optional]
         Status to show whether the deployment was approved or not. It also shows up as a part of metadata within the prediction response.. 
    governance:DeploymentGovernanceResponse [optional]
         
    importance:str [optional]
         Shows how important this deployment is.. 
    model_package:DeploymentModelPackageResponse [optional]
         
    model_package_initial_download:DeploymentModelPackageInitialDownloadResponse [optional]
         
    opened_change_requests:[str] [optional]
         An array of the change request IDs related to this deployment that have.. 
    owners:DeploymentOwnersResponse [optional]
         
    prediction_environment:DeploymentPredictionEnvironmentResponse [optional]
         
    scoring_code_initial_download:DeploymentScoringCodeInitialDownloadResponse [optional]
         
    state:str [optional]
         Displays current state of the deployment. 
    """
    _converter = t.Dict(
        {
            t.Key("accuracy_health"):  t.Any(),
            t.Key("capabilities"):  t.Any(),
            t.Key("created_at"):  t.DateTime(),
            t.Key("default_prediction_server"):  t.Any(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("label"):  t.String(),
            t.Key("model"):  t.Any(),
            t.Key("model_health"):  t.Any(),
            t.Key("permissions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_usage"):  t.Any(),
            t.Key("service_health"):  t.Any(),
            t.Key("settings"):  t.Any(),
            t.Key("status"):  t.String(),
            t.Key("approval_status", optional=True):  t.String(),
            t.Key("governance", optional=True):  t.Any(),
            t.Key("importance", optional=True):  t.String(),
            t.Key("model_package", optional=True):  t.Any(),
            t.Key("model_package_initial_download", optional=True):  t.Any(),
            t.Key("opened_change_requests", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("owners", optional=True):  t.Any(),
            t.Key("prediction_environment", optional=True):  t.Any(),
            t.Key("scoring_code_initial_download", optional=True):  t.Any(),
            t.Key("state", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        accuracy_health,
        capabilities,
        created_at,
        default_prediction_server,
        description,
        id,
        label,
        model,
        model_health,
        permissions,
        prediction_usage,
        service_health,
        settings,
        status,
        approval_status=None,
        governance=None,
        importance=None,
        model_package=None,
        model_package_initial_download=None,
        opened_change_requests=None,
        owners=None,
        prediction_environment=None,
        scoring_code_initial_download=None,
        state=None,
    ):
        self.accuracy_health = accuracy_health
        self.capabilities = capabilities
        self.created_at = created_at
        self.default_prediction_server = default_prediction_server
        self.description = description
        self.id = id
        self.label = label
        self.model = model
        self.model_health = model_health
        self.permissions = permissions
        self.prediction_usage = prediction_usage
        self.service_health = service_health
        self.settings = settings
        self.status = status
        self.approval_status = approval_status
        self.governance = governance
        self.importance = importance
        self.model_package = model_package
        self.model_package_initial_download = model_package_initial_download
        self.opened_change_requests = opened_change_requests
        self.owners = owners
        self.prediction_environment = prediction_environment
        self.scoring_code_initial_download = scoring_code_initial_download
        self.state = state

    def __repr__(self):
        return (
            "DeploymentRetrieveResponse("
            "accuracy_health={0.accuracy_health}, "
            "capabilities={0.capabilities}, "
            "created_at={0.created_at}, "
            "default_prediction_server={0.default_prediction_server}, "
            "description={0.description}, "
            "id={0.id}, "
            "label={0.label}, "
            "model={0.model}, "
            "model_health={0.model_health}, "
            "permissions={0.permissions}, "
            "prediction_usage={0.prediction_usage}, "
            "service_health={0.service_health}, "
            "settings={0.settings}, "
            "status={0.status}, "
            "approval_status={0.approval_status}, "
            "governance={0.governance}, "
            "importance={0.importance}, "
            "model_package={0.model_package}, "
            "model_package_initial_download={0.model_package_initial_download}, "
            "opened_change_requests={0.opened_change_requests}, "
            "owners={0.owners}, "
            "prediction_environment={0.prediction_environment}, "
            "scoring_code_initial_download={0.scoring_code_initial_download}, "
            "state={0.state}, "
        ).format(self)
