#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.association_id_update import AssociationIDUpdate
from datarobot.models.full_api.generated.model.automati_actuals import AutomatiActuals
from datarobot.models.full_api.generated.model.challengers import Challengers
from datarobot.models.full_api.generated.model.feature_drift_update import FeatureDriftUpdate
from datarobot.models.full_api.generated.model.forecast_date import ForecastDate
from datarobot.models.full_api.generated.model.humility import Humility
from datarobot.models.full_api.generated.model.prediction_intervals_update import PredictionIntervalsUpdate
from datarobot.models.full_api.generated.model.prediction_warning_update import PredictionWarningUpdate
from datarobot.models.full_api.generated.model.predictions_data_collection import PredictionsDataCollection
from datarobot.models.full_api.generated.model.segment_analysis_update import SegmentAnalysisUpdate
from datarobot.models.full_api.generated.model.target_drift_update import TargetDriftUpdate

class DeploymentSettingsUpdate(APIObject):
    """
    Attributes
    ----------
    association_id:AssociationIDUpdate [optional]
         
    automatic_actuals:AutomatiActuals [optional]
         
    challenger_models:Challengers [optional]
         
    feature_drift:FeatureDriftUpdate [optional]
         
    humility:Humility [optional]
         
    prediction_intervals:PredictionIntervalsUpdate [optional]
         
    prediction_warning:PredictionWarningUpdate [optional]
         
    predictions_by_forecast_date:ForecastDate [optional]
         
    predictions_data_collection:PredictionsDataCollection [optional]
         
    segment_analysis:SegmentAnalysisUpdate [optional]
         
    target_drift:TargetDriftUpdate [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("association_id", optional=True):  t.Any(),
            t.Key("automatic_actuals", optional=True):  t.Any(),
            t.Key("challenger_models", optional=True):  t.Any(),
            t.Key("feature_drift", optional=True):  t.Any(),
            t.Key("humility", optional=True):  t.Any(),
            t.Key("prediction_intervals", optional=True):  t.Any(),
            t.Key("prediction_warning", optional=True):  t.Any(),
            t.Key("predictions_by_forecast_date", optional=True):  t.Any(),
            t.Key("predictions_data_collection", optional=True):  t.Any(),
            t.Key("segment_analysis", optional=True):  t.Any(),
            t.Key("target_drift", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        association_id=None,
        automatic_actuals=None,
        challenger_models=None,
        feature_drift=None,
        humility=None,
        prediction_intervals=None,
        prediction_warning=None,
        predictions_by_forecast_date=None,
        predictions_data_collection=None,
        segment_analysis=None,
        target_drift=None,
    ):
        self.association_id = association_id
        self.automatic_actuals = automatic_actuals
        self.challenger_models = challenger_models
        self.feature_drift = feature_drift
        self.humility = humility
        self.prediction_intervals = prediction_intervals
        self.prediction_warning = prediction_warning
        self.predictions_by_forecast_date = predictions_by_forecast_date
        self.predictions_data_collection = predictions_data_collection
        self.segment_analysis = segment_analysis
        self.target_drift = target_drift

    def __repr__(self):
        return (
            "DeploymentSettingsUpdate("
            "association_id={0.association_id}, "
            "automatic_actuals={0.automatic_actuals}, "
            "challenger_models={0.challenger_models}, "
            "feature_drift={0.feature_drift}, "
            "humility={0.humility}, "
            "prediction_intervals={0.prediction_intervals}, "
            "prediction_warning={0.prediction_warning}, "
            "predictions_by_forecast_date={0.predictions_by_forecast_date}, "
            "predictions_data_collection={0.predictions_data_collection}, "
            "segment_analysis={0.segment_analysis}, "
            "target_drift={0.target_drift}, "
        ).format(self)
