#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.time_range import TimeRange

class DeploymentTargetDriftResponse(APIObject):
    """
    Attributes
    ----------
    baseline_sample_size:int
         sample size of the training data.
    drift_score:float, none_type
         drift score for the target.
    model_id:str
         id of the model for which data drift is being retrieved.
    period:TimeRange
        
    sample_size:int
         number of predictions used to compute the drift score.
    target_name:str
         name of the target feature.
    metric:str [optional]
         Metric used to calculate drift score.. 
    segment_attribute:str, none_type [optional]
         The name of the segment on which segment analysis is being performed.. 
    segment_value:str, none_type [optional]
         The value of the `segmentAttribute` to segment on..  if omitted the server will use the default value of ""
    """
    _converter = t.Dict(
        {
            t.Key("baseline_sample_size"):  t.Int(),
            t.Key("drift_score"):  t.Float(),
            t.Key("model_id"):  t.String(),
            t.Key("period"):  t.Any(),
            t.Key("sample_size"):  t.Int(),
            t.Key("target_name"):  t.String(),
            t.Key("metric", optional=True):  t.String(),
            t.Key("segment_attribute", optional=True):  t.String(),
            t.Key("segment_value", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        baseline_sample_size,
        drift_score,
        model_id,
        period,
        sample_size,
        target_name,
        metric=None,
        segment_attribute=None,
        segment_value=None,
    ):
        self.baseline_sample_size = baseline_sample_size
        self.drift_score = drift_score
        self.model_id = model_id
        self.period = period
        self.sample_size = sample_size
        self.target_name = target_name
        self.metric = metric
        self.segment_attribute = segment_attribute
        self.segment_value = segment_value

    def __repr__(self):
        return (
            "DeploymentTargetDriftResponse("
            "baseline_sample_size={0.baseline_sample_size}, "
            "drift_score={0.drift_score}, "
            "model_id={0.model_id}, "
            "period={0.period}, "
            "sample_size={0.sample_size}, "
            "target_name={0.target_name}, "
            "metric={0.metric}, "
            "segment_attribute={0.segment_attribute}, "
            "segment_value={0.segment_value}, "
        ).format(self)
