#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DeprecatedCustomModelWorkspaceItemResponse(APIObject):
    """
    Attributes
    ----------
    created:str
         ISO-8601 timestamp of when the file item was created.
    file_name:str
         Name of the file item.
    file_path:str
         Path of the file item.
    file_source:str
         Source of the file item.
    id:str
         ID of the file item.
    storage_path:str
         Storage path of the file item.
    workspace_id:str
         Workspace ID of the file item.
    commit_sha:str, none_type [optional]
         SHA1 hash pointing to the original file revision (set only for files pulled from Git-like repositories).. 
    ref:str, none_type [optional]
         Remote reference (branch, commit, tag). Branch \"master\", if not specified.. 
    repository_file_path:str, none_type [optional]
         Full path to the file in the remote repository.. 
    repository_location:str, none_type [optional]
         URL to remote repository from which the file was pulled (e.g. Git server or S3 Bucket name).. 
    repository_name:str, none_type [optional]
         Name of the repository from which the file was pulled.. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.String(),
            t.Key("file_name"):  t.String(),
            t.Key("file_path"):  t.String(),
            t.Key("file_source"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("storage_path"):  t.String(),
            t.Key("workspace_id"):  t.String(),
            t.Key("commit_sha", optional=True):  t.String(),
            t.Key("ref", optional=True):  t.String(),
            t.Key("repository_file_path", optional=True):  t.String(),
            t.Key("repository_location", optional=True):  t.String(),
            t.Key("repository_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        file_name,
        file_path,
        file_source,
        id,
        storage_path,
        workspace_id,
        commit_sha=None,
        ref=None,
        repository_file_path=None,
        repository_location=None,
        repository_name=None,
    ):
        self.created = created
        self.file_name = file_name
        self.file_path = file_path
        self.file_source = file_source
        self.id = id
        self.storage_path = storage_path
        self.workspace_id = workspace_id
        self.commit_sha = commit_sha
        self.ref = ref
        self.repository_file_path = repository_file_path
        self.repository_location = repository_location
        self.repository_name = repository_name

    def __repr__(self):
        return (
            "DeprecatedCustomModelWorkspaceItemResponse("
            "created={0.created}, "
            "file_name={0.file_name}, "
            "file_path={0.file_path}, "
            "file_source={0.file_source}, "
            "id={0.id}, "
            "storage_path={0.storage_path}, "
            "workspace_id={0.workspace_id}, "
            "commit_sha={0.commit_sha}, "
            "ref={0.ref}, "
            "repository_file_path={0.repository_file_path}, "
            "repository_location={0.repository_location}, "
            "repository_name={0.repository_name}, "
        ).format(self)
