#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.stage_coefficients import StageCoefficients
from datarobot.models.full_api.generated.model.transformations import Transformations

class DerivedFeatures(APIObject):
    """
    Attributes
    ----------
    coefficient:float
         The coefficient for this feature.
    derived_feature:str
         The name of the derived feature.
    original_feature:str
         The name of the feature used to derive this feature.
    stage_coefficients:[StageCoefficients]
         An array of json objects describing separate coefficients for every stage of model (empty for single stage models).
    transformations:[Transformations]
         An array of json objects describing the transformations applied to create this derived feature.
    type:str
         The type of this feature.
    """
    _converter = t.Dict(
        {
            t.Key("coefficient"):  t.Float(),
            t.Key("derived_feature"):  t.String(),
            t.Key("original_feature"):  t.String(),
            t.Key("stage_coefficients"):  t.List(t.Dict().allow_extra("*")),
            t.Key("transformations"):  t.List(t.Dict().allow_extra("*")),
            t.Key("type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        coefficient,
        derived_feature,
        original_feature,
        stage_coefficients,
        transformations,
        type,
    ):
        self.coefficient = coefficient
        self.derived_feature = derived_feature
        self.original_feature = original_feature
        self.stage_coefficients = stage_coefficients
        self.transformations = transformations
        self.type = type

    def __repr__(self):
        return (
            "DerivedFeatures("
            "coefficient={0.coefficient}, "
            "derived_feature={0.derived_feature}, "
            "original_feature={0.original_feature}, "
            "stage_coefficients={0.stage_coefficients}, "
            "transformations={0.transformations}, "
            "type={0.type}, "
        ).format(self)
