#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DocTypeSpecificInfo(APIObject):
    """
    Attributes
    ----------
    end_date:datetime
         End date of selected data in the document.
    start_date:datetime
         Start date of selected data in the document.
    model_name:str [optional]
         Name of the deployed model.. 
    """
    _converter = t.Dict(
        {
            t.Key("end_date"):  t.DateTime(),
            t.Key("start_date"):  t.DateTime(),
            t.Key("model_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        end_date,
        start_date,
        model_name=None,
    ):
        self.end_date = end_date
        self.start_date = start_date
        self.model_name = model_name

    def __repr__(self):
        return (
            "DocTypeSpecificInfo("
            "end_date={0.end_date}, "
            "start_date={0.start_date}, "
            "model_name={0.model_name}, "
        ).format(self)
