#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.connector_field_schema import ConnectorFieldSchema
from datarobot.models.full_api.generated.model.dr_connector_v1_field import DRConnectorV1Field

class DRConnectorV1Details(APIObject):
    """
    Attributes
    ----------
    connector_id:str
         ID of the connector.
    fields:[DRConnectorV1Field]
         Connector fields.
    field_schemas:[ConnectorFieldSchema] [optional]
         Connector field schemas.. 
    """
    _converter = t.Dict(
        {
            t.Key("connector_id"):  t.String(),
            t.Key("fields"):  t.List(t.Dict().allow_extra("*")),
            t.Key("field_schemas", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        connector_id,
        fields,
        field_schemas=None,
    ):
        self.connector_id = connector_id
        self.fields = fields
        self.field_schemas = field_schemas

    def __repr__(self):
        return (
            "DRConnectorV1Details("
            "connector_id={0.connector_id}, "
            "fields={0.fields}, "
            "field_schemas={0.field_schemas}, "
        ).format(self)
