#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DRConnectorV1Field(APIObject):
    """
    Attributes
    ----------
    name:str
         User-friendly displayable connector field name.
    value:str
         Connector field value.
    id:str [optional]
         Connector field name.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("value"):  t.String(),
            t.Key("id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        value,
        id=None,
    ):
        self.name = name
        self.value = value
        self.id = id

    def __repr__(self):
        return (
            "DRConnectorV1Field("
            "name={0.name}, "
            "value={0.value}, "
            "id={0.id}, "
        ).format(self)
