#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DrUserId(APIObject):
    """
    Attributes
    ----------
    id:str
         The DR user ID
    first_name:str, none_type [optional]
         First name of use case owner. 
    last_name:str, none_type [optional]
         Last of use case owner. 
    username:str [optional]
         Username of use case owner. 
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("first_name", optional=True):  t.String(),
            t.Key("last_name", optional=True):  t.String(),
            t.Key("username", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        first_name=None,
        last_name=None,
        username=None,
    ):
        self.id = id
        self.first_name = first_name
        self.last_name = last_name
        self.username = username

    def __repr__(self):
        return (
            "DrUserId("
            "id={0.id}, "
            "first_name={0.first_name}, "
            "last_name={0.last_name}, "
            "username={0.username}, "
        ).format(self)
