#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.jdbc_field_schemas import JDBCFieldSchemas

class DriverConfigurationRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    associated_auth_types:[str]
         List of authentication types supported by this driver configuration.
    class_name:str
         Java class name of the driver to be used (e.g., org.postgresql.Driver).
    creator:str
         User ID of the creator of this configuration.
    id:str
         Driver configuration ID
    jdbc_field_schemas:JDBCFieldSchemas
        
    jdbc_url_path_delimiter:str
         Separator of address from path in the JDBC URL (e.g., \"/\").
    jdbc_url_prefix:str
         Prefix of the JDBC URL (e.g., \"jdbc:mssql://\" or \"jdbc:oracle:thin:@\").
    jdbc_url_query_delimiter:str
         Separator of path from the list of query parameters in the JDBC URL (e.g., \"?\").
    jdbc_url_query_param_delimiter:str
         Separator of each set of query parameter key-value pairs in the JDBC URL (e.g., \"&\").
    jdbc_url_query_param_key_value_delimiter:str
         Separator of the key and value in a query parameter pair (e.g., \"=\").
    standardized_name:str
         Plain text name for the driver (e.g., PostgreSQL).
    updated:str
         ISO-8601 formatted time/date when this configuration was most recently updated.
    """
    _converter = t.Dict(
        {
            t.Key("associated_auth_types"):  t.List(t.Dict().allow_extra("*")),
            t.Key("class_name"):  t.String(),
            t.Key("creator"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("jdbc_field_schemas"):  t.Any(),
            t.Key("jdbc_url_path_delimiter"):  t.String(),
            t.Key("jdbc_url_prefix"):  t.String(),
            t.Key("jdbc_url_query_delimiter"):  t.String(),
            t.Key("jdbc_url_query_param_delimiter"):  t.String(),
            t.Key("jdbc_url_query_param_key_value_delimiter"):  t.String(),
            t.Key("standardized_name"):  t.String(),
            t.Key("updated"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        associated_auth_types,
        class_name,
        creator,
        id,
        jdbc_field_schemas,
        jdbc_url_path_delimiter,
        jdbc_url_prefix,
        jdbc_url_query_delimiter,
        jdbc_url_query_param_delimiter,
        jdbc_url_query_param_key_value_delimiter,
        standardized_name,
        updated,
    ):
        self.associated_auth_types = associated_auth_types
        self.class_name = class_name
        self.creator = creator
        self.id = id
        self.jdbc_field_schemas = jdbc_field_schemas
        self.jdbc_url_path_delimiter = jdbc_url_path_delimiter
        self.jdbc_url_prefix = jdbc_url_prefix
        self.jdbc_url_query_delimiter = jdbc_url_query_delimiter
        self.jdbc_url_query_param_delimiter = jdbc_url_query_param_delimiter
        self.jdbc_url_query_param_key_value_delimiter = jdbc_url_query_param_key_value_delimiter
        self.standardized_name = standardized_name
        self.updated = updated

    def __repr__(self):
        return (
            "DriverConfigurationRetrieveResponse("
            "associated_auth_types={0.associated_auth_types}, "
            "class_name={0.class_name}, "
            "creator={0.creator}, "
            "id={0.id}, "
            "jdbc_field_schemas={0.jdbc_field_schemas}, "
            "jdbc_url_path_delimiter={0.jdbc_url_path_delimiter}, "
            "jdbc_url_prefix={0.jdbc_url_prefix}, "
            "jdbc_url_query_delimiter={0.jdbc_url_query_delimiter}, "
            "jdbc_url_query_param_delimiter={0.jdbc_url_query_param_delimiter}, "
            "jdbc_url_query_param_key_value_delimiter={0.jdbc_url_query_param_key_value_delimiter}, "
            "standardized_name={0.standardized_name}, "
            "updated={0.updated}, "
        ).format(self)
