#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DriverResponse(APIObject):
    """
    Attributes
    ----------
    creator:str
         ID of the user who uploaded the driver.
    id:str
         Driver ID.
    associated_auth_types:[str] [optional]
         Authentication types associated with this connector configuration.. 
    base_names:[str] [optional]
         Original file name(s) of the uploaded JAR file(s). If there are multiple JAR files required for the driver, each of the original file names should be present in the list in the same order as found in 'localJarUrls'. 
    canonical_name:str [optional]
         User-friendly driver name.. 
    class_name:str [optional]
         Driver class name. For example 'com.amazon.redshift.jdbc.Driver'). 
    configuration_id:str, none_type [optional]
         Driver configuration ID if it was provided during driver upload.. 
    version:str [optional]
         Driver version, which is used to construct the canonical name if driver configuration ID was provided during driver upload.. 
    """
    _converter = t.Dict(
        {
            t.Key("creator"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("associated_auth_types", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("base_names", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("canonical_name", optional=True):  t.String(),
            t.Key("class_name", optional=True):  t.String(),
            t.Key("configuration_id", optional=True):  t.String(),
            t.Key("version", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        creator,
        id,
        associated_auth_types=None,
        base_names=None,
        canonical_name=None,
        class_name=None,
        configuration_id=None,
        version=None,
    ):
        self.creator = creator
        self.id = id
        self.associated_auth_types = associated_auth_types
        self.base_names = base_names
        self.canonical_name = canonical_name
        self.class_name = class_name
        self.configuration_id = configuration_id
        self.version = version

    def __repr__(self):
        return (
            "DriverResponse("
            "creator={0.creator}, "
            "id={0.id}, "
            "associated_auth_types={0.associated_auth_types}, "
            "base_names={0.base_names}, "
            "canonical_name={0.canonical_name}, "
            "class_name={0.class_name}, "
            "configuration_id={0.configuration_id}, "
            "version={0.version}, "
        ).format(self)
