#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DSS(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of the dataset
    project_id:str
         The ID of the project
    type:str
         Type name for this intake type. defaults to "dss", must be one of ["dss", ]
    partition:str [optional]
         Partition used to predict.  if omitted the server will use the default value of "null"
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("partition", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        project_id,
        type,
        partition=None,
    ):
        self.dataset_id = dataset_id
        self.project_id = project_id
        self.type = type
        self.partition = partition

    def __repr__(self):
        return (
            "DSS("
            "dataset_id={0.dataset_id}, "
            "project_id={0.project_id}, "
            "type={0.type}, "
            "partition={0.partition}, "
        ).format(self)
