#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class DuplicateImageItem(APIObject):
    """
    Attributes
    ----------
    image_id:str
         Id of the image. The actual image file can be retrieved with :http:get:`/api/v2/projects/(projectId)/images/(imageId)/file/`
    row_count:int
         The count of duplicate images i.e. number of times this image is used in column
    """
    _converter = t.Dict(
        {
            t.Key("image_id"):  t.String(),
            t.Key("row_count"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        image_id,
        row_count,
    ):
        self.image_id = image_id
        self.row_count = row_count

    def __repr__(self):
        return (
            "DuplicateImageItem("
            "image_id={0.image_id}, "
            "row_count={0.row_count}, "
        ).format(self)
