#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.image_embedding import ImageEmbedding
from datarobot.models.full_api.generated.model.target_bin import TargetBin

class EmbeddingsRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    embeddings:[ImageEmbedding]
         List of Image Embedding objects
    target_bins:[TargetBin], none_type
         List of bin objects for regression or null
    target_values:[str], none_type
         List of target values for classification or null
    """
    _converter = t.Dict(
        {
            t.Key("embeddings"):  t.List(t.Dict().allow_extra("*")),
            t.Key("target_bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("target_values"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        embeddings,
        target_bins,
        target_values,
    ):
        self.embeddings = embeddings
        self.target_bins = target_bins
        self.target_values = target_values

    def __repr__(self):
        return (
            "EmbeddingsRetrieveResponse("
            "embeddings={0.embeddings}, "
            "target_bins={0.target_bins}, "
            "target_values={0.target_values}, "
        ).format(self)
