#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class EncryptionKeypairs(APIObject):
    """
    Attributes
    ----------
    cert_file:str [optional]
         Path to the pem file with a single certificate.. 
    cert_file_value:str [optional]
         A single certificate pem file content as a single string. Has priority over cert_file.. 
    key_file:str [optional]
         Path to the private key pem file.. 
    key_file_value:str [optional]
         The private key pem file content as a single string. Has priority over key_file.. 
    """
    _converter = t.Dict(
        {
            t.Key("cert_file", optional=True):  t.String(),
            t.Key("cert_file_value", optional=True):  t.String(),
            t.Key("key_file", optional=True):  t.String(),
            t.Key("key_file_value", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        cert_file=None,
        cert_file_value=None,
        key_file=None,
        key_file_value=None,
    ):
        self.cert_file = cert_file
        self.cert_file_value = cert_file_value
        self.key_file = key_file
        self.key_file_value = key_file_value

    def __repr__(self):
        return (
            "EncryptionKeypairs("
            "cert_file={0.cert_file}, "
            "cert_file_value={0.cert_file_value}, "
            "key_file={0.key_file}, "
            "key_file_value={0.key_file_value}, "
        ).format(self)
