#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class EntityCountByTypeResponse(APIObject):
    """
    Attributes
    ----------
    num_calendars:int
         The number of calendars that use the dataset
    num_external_model_packages:int
         The number of external model packages that use the dataset
    num_feature_discovery_configs:int
         The number of feature discovery configs that use the dataset
    num_prediction_datasets:int
         The number of prediction datasets that use the dataset
    num_projects:int
         The number of projects that use the dataset
    num_spark_sql_queries:int
         The number of spark sql queries that use the dataset
    """
    _converter = t.Dict(
        {
            t.Key("num_calendars"):  t.Int(),
            t.Key("num_external_model_packages"):  t.Int(),
            t.Key("num_feature_discovery_configs"):  t.Int(),
            t.Key("num_prediction_datasets"):  t.Int(),
            t.Key("num_projects"):  t.Int(),
            t.Key("num_spark_sql_queries"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        num_calendars,
        num_external_model_packages,
        num_feature_discovery_configs,
        num_prediction_datasets,
        num_projects,
        num_spark_sql_queries,
    ):
        self.num_calendars = num_calendars
        self.num_external_model_packages = num_external_model_packages
        self.num_feature_discovery_configs = num_feature_discovery_configs
        self.num_prediction_datasets = num_prediction_datasets
        self.num_projects = num_projects
        self.num_spark_sql_queries = num_spark_sql_queries

    def __repr__(self):
        return (
            "EntityCountByTypeResponse("
            "num_calendars={0.num_calendars}, "
            "num_external_model_packages={0.num_external_model_packages}, "
            "num_feature_discovery_configs={0.num_feature_discovery_configs}, "
            "num_prediction_datasets={0.num_prediction_datasets}, "
            "num_projects={0.num_projects}, "
            "num_spark_sql_queries={0.num_spark_sql_queries}, "
        ).format(self)
