#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.classification_bin_data_response import ClassificationBinDataResponse

class EureqaDistributionDetailResponse(APIObject):
    """
    Attributes
    ----------
    bins:[ClassificationBinDataResponse]
         The distribution plot data.
    complexity:int
         The complexity score for this solution. Complexity score is a function of the mathematical operators used in the current solution. The complexity calculation can be tuned via model hyperparameters.
    error:float, none_type
         The error for the current solution, as computed by eureqa using the `errorMetric` error metric. None if Eureqa model refitted existing solutions.
    error_metric:str
         The Eureqa error metric identifier used to compute error metrics for this search. Note that Eureqa error metrics do not correspond 1:1 with DataRobot error metrics - the available metrics are not the same, and even equivalent metrics may be computed slightly differently.
    eureqa_solution_id:str
         The ID of the solution.
    expression:str
         The eureqa \"solution string\". This is a mathematical expression; human-readable but with strict syntax specifications defined by Eureqa.
    expression_annotated:str
         The `expression`, rendered with additional tags to assist in automatic parsing.
    threshold:float
         Classifier threshold selected by the backend, used to determine which model values are binned as positive and which are binned as negative. Must have a value between the `binStart` of the first bin and `binEnd` of the last bin.
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("complexity"):  t.Int(),
            t.Key("error"):  t.Float(),
            t.Key("error_metric"):  t.String(),
            t.Key("eureqa_solution_id"):  t.String(),
            t.Key("expression"):  t.String(),
            t.Key("expression_annotated"):  t.String(),
            t.Key("threshold"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        complexity,
        error,
        error_metric,
        eureqa_solution_id,
        expression,
        expression_annotated,
        threshold,
    ):
        self.bins = bins
        self.complexity = complexity
        self.error = error
        self.error_metric = error_metric
        self.eureqa_solution_id = eureqa_solution_id
        self.expression = expression
        self.expression_annotated = expression_annotated
        self.threshold = threshold

    def __repr__(self):
        return (
            "EureqaDistributionDetailResponse("
            "bins={0.bins}, "
            "complexity={0.complexity}, "
            "error={0.error}, "
            "error_metric={0.error_metric}, "
            "eureqa_solution_id={0.eureqa_solution_id}, "
            "expression={0.expression}, "
            "expression_annotated={0.expression_annotated}, "
            "threshold={0.threshold}, "
        ).format(self)
