#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class EureqaLeaderboardEntryPayload(APIObject):
    """
    Attributes
    ----------
    solution_id:str
         the ID of the solution to be cloned.
    parent_model_id:str [optional]
         The ID of the model to clone from. If omitted, will automatically search for and find the first leaderboard model created by the blueprint run that also created the solution associated with `solutionId`.. 
    """
    _converter = t.Dict(
        {
            t.Key("solution_id"):  t.String(),
            t.Key("parent_model_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        solution_id,
        parent_model_id=None,
    ):
        self.solution_id = solution_id
        self.parent_model_id = parent_model_id

    def __repr__(self):
        return (
            "EureqaLeaderboardEntryPayload("
            "solution_id={0.solution_id}, "
            "parent_model_id={0.parent_model_id}, "
        ).format(self)
